<?php
/**
 * Background Mask Style - Honeycomb.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Honeycomb
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Honeycomb extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Honeycomb', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1864.72,1098.91,1785.26,1053a33.58,33.58,0,0,1-16.74-29V932.3a33.58,33.58,0,0,1,16.74-29l79.46-45.87a33.58,33.58,0,0,1,33.48,0L1920,870V560l-25.61,14.78a28.2,28.2,0,0,1-28.1,0L1795.72,534a28.19,28.19,0,0,1-14-24.34V428.18a28.19,28.19,0,0,1,14-24.34l70.57-40.74a28.2,28.2,0,0,1,28.1,0L1920,377.89V0H1718.91V12.52a40.94,40.94,0,0,1-20.41,35.36l-91.57,52.87a41,41,0,0,1-37.74,1.59q-1.31-.84-2.64-1.62L1475,47.86c-1-.61-2.11-1.17-3.17-1.71a41,41,0,0,1-17.7-33.63V0h-29.77V12.38a41,41,0,0,1-20.42,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0L1180,47.74a40.94,40.94,0,0,1-20.41-35.36V0H0V1440H1197.13v-1.21a26.68,26.68,0,0,1,13.31-23l68.12-39.33a26.71,26.71,0,0,1,26.61,0l68.12,39.33a26.67,26.67,0,0,1,13.3,23V1440H1920V1086.33l-21.8,12.58A33.58,33.58,0,0,1,1864.72,1098.91Zm-18.17-463.22A41,41,0,0,1,1867,671.05V776.79a41,41,0,0,1-20.42,35.36L1755,865a40.93,40.93,0,0,1-39.36.79c-.45-.27-.89-.55-1.35-.81l-91.57-52.87c-.48-.28-1-.54-1.47-.81a40.93,40.93,0,0,1-19.06-34.52V671.05a40.94,40.94,0,0,1,20.41-35.36l91.57-52.87a41,41,0,0,1,40.83,0ZM1678.94,192.14a14.87,14.87,0,0,1,7.41-12.83l38.86-22.44a14.86,14.86,0,0,1,14.82,0l38.86,22.44a14.87,14.87,0,0,1,7.41,12.83V237a14.87,14.87,0,0,1-7.41,12.83L1740,272.29a14.86,14.86,0,0,1-14.82,0l-38.86-22.44a14.87,14.87,0,0,1-7.41-12.83Zm-92.1,130.47a40.74,40.74,0,0,1,20.41,5.46l91.57,52.86a40.93,40.93,0,0,1,20.42,35.36V522a40.93,40.93,0,0,1-20.42,35.36l-91.57,52.87a40.92,40.92,0,0,1-37.68,1.61c-1-.61-1.91-1.21-2.9-1.77l-91.57-52.87c-1-.6-2.08-1.16-3.14-1.7a40.94,40.94,0,0,1-17.52-33.5V416.29a40.93,40.93,0,0,1,19.07-34.52q.73-.39,1.47-.81l91.57-52.87c.45-.26.89-.53,1.33-.8A40.9,40.9,0,0,1,1586.84,322.61ZM1307.46,161.54a41,41,0,0,1,20.42-35.36l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87a40.94,40.94,0,0,1,20.41,35.36V267.27a41,41,0,0,1-20.41,35.37l-91.57,52.86a40.94,40.94,0,0,1-40.83,0l-91.57-52.86a41,41,0,0,1-20.42-35.37Zm-35.61,166.39a41,41,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V521.89a41,41,0,0,1-20.42,35.36l-91.57,52.87a41,41,0,0,1-37.68,1.62c-1.06-.69-2.13-1.36-3.22-2l-91.57-52.87c-1-.57-2-1.12-3-1.64a41,41,0,0,1-17.31-33.35V416.16a41,41,0,0,1,20.42-35.36Zm-240.24-159.8a33.86,33.86,0,0,1,16.88-29.24l79.92-46.14a33.84,33.84,0,0,1,33.76,0l79.92,46.14A33.86,33.86,0,0,1,1259,168.13v92.28a33.86,33.86,0,0,1-16.88,29.24l-79.92,46.14a33.86,33.86,0,0,1-33.76,0l-79.92-46.14a33.86,33.86,0,0,1-16.88-29.24ZM1012.7,776.3V670.57a40.94,40.94,0,0,1,20.41-35.36l91.57-52.87a40.9,40.9,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V776.3a41,41,0,0,1-20.42,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0l-91.57-52.87A40.94,40.94,0,0,1,1012.7,776.3ZM1240.34,1264a26.88,26.88,0,0,1-13.41,23.21l-68.43,39.51a26.88,26.88,0,0,1-26.8,0l-68.44-39.51a26.87,26.87,0,0,1-13.4-23.21v-79a26.87,26.87,0,0,1,13.4-23.21l68.44-39.51a26.87,26.87,0,0,1,26.8,0l68.43,39.51a26.88,26.88,0,0,1,13.41,23.21Zm123.25-254.81a17.53,17.53,0,0,1-8.75,15.15L1301.76,1055a17.56,17.56,0,0,1-17.49,0l-53.08-30.65a17.54,17.54,0,0,1-8.74-15.15V947.89a17.55,17.55,0,0,1,8.74-15.15l53.08-30.64a17.51,17.51,0,0,1,17.49,0l53.08,30.64a17.54,17.54,0,0,1,8.75,15.15ZM1328,812a41,41,0,0,1-20.42-35.36V670.91A41,41,0,0,1,1328,635.55l91.57-52.87a41,41,0,0,1,40.83,0L1552,635.55a40.94,40.94,0,0,1,20.41,35.36V776.65A40.94,40.94,0,0,1,1552,812l-91.57,52.87a40.94,40.94,0,0,1-40.83,0Zm136.1,434.77-23.36,13.49-23.37-13.49v-27l23.37-13.48,23.36,13.48Zm103.07-127-91.57-52.87a40.93,40.93,0,0,1-20.42-35.36V925.81a40.93,40.93,0,0,1,20.42-35.36l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87A40.94,40.94,0,0,1,1720,925.81v105.73a40.94,40.94,0,0,1-20.41,35.36L1608,1119.77A40.94,40.94,0,0,1,1567.18,1119.77Zm300.54,166.53a40.94,40.94,0,0,1-20.41,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0l-91.57-52.87a40.93,40.93,0,0,1-20.42-35.36V1180.56a40.93,40.93,0,0,1,20.42-35.36l91.56-52.87a41,41,0,0,1,40.84,0l91.57,52.87a40.94,40.94,0,0,1,20.41,35.36Z"/>',
					'portrait'  => '<path d="M1808.38,1912.2V1774.92a53.15,53.15,0,0,1,26.5-45.91l85.12-49.14v-44.51L1815,1696a53.2,53.2,0,0,1-53,0l-118.89-68.64a53.15,53.15,0,0,1-26.5-45.91V1444.17a53.15,53.15,0,0,1,26.5-45.91L1762,1329.62a53.15,53.15,0,0,1,53,0l105,60.64v-44.07l-85.94-49.62c-.74-.42-1.49-.84-2.24-1.24a53.17,53.17,0,0,1-24.42-44.64V1113.42a53.15,53.15,0,0,1,26.5-45.91l86.1-49.71V973.29l-106,61.2a53.18,53.18,0,0,1-48.93,2.1q-1.85-1.2-3.75-2.31l-118.89-68.64q-2.07-1.18-4.19-2.26a53.16,53.16,0,0,1-22.64-43.44V782.67A53.2,53.2,0,0,1,1640,738c.75-.4,1.5-.81,2.23-1.23l118.89-68.64c.59-.34,1.16-.7,1.74-1a53.07,53.07,0,0,1,51.11,1l106,61.2V311.54L1813.58,373a53.14,53.14,0,0,1-49,2.07c-1.12-.72-2.26-1.42-3.43-2.1l-118.89-68.63c-1.37-.8-2.77-1.55-4.18-2.26a53.17,53.17,0,0,1-22.91-43.62V121.16a53.16,53.16,0,0,1,26.51-45.91L1760.57,6.61A52.86,52.86,0,0,1,1780.06,0H1412.74a52.73,52.73,0,0,1,18.39,6.43L1550,75.07A53.16,53.16,0,0,1,1576.52,121V258.26A53.16,53.16,0,0,1,1550,304.17l-118.88,68.64a53.18,53.18,0,0,1-53,0l-118.89-68.64a53.15,53.15,0,0,1-26.5-45.91V121a53.15,53.15,0,0,1,26.5-45.91L1378.12,6.43A52.73,52.73,0,0,1,1396.51,0H0V2560H1920V2007.25l-85.12-49.14A53.15,53.15,0,0,1,1808.38,1912.2Zm-185-913.51,118.89,68.64a53.17,53.17,0,0,1,26.5,45.91v137.28a53.16,53.16,0,0,1-26.5,45.9l-118.89,68.64a53.15,53.15,0,0,1-53,0l-118.89-68.64a53.14,53.14,0,0,1-26.5-45.9V1113.24a53.15,53.15,0,0,1,26.5-45.91l118.89-68.64a53.15,53.15,0,0,1,53,0Zm-125.7,474.15v79.58a22.76,22.76,0,0,1-11.36,19.66l-68.91,39.79a22.74,22.74,0,0,1-22.71,0l-68.91-39.79a22.76,22.76,0,0,1-11.36-19.66v-79.58a22.77,22.77,0,0,1,11.36-19.67l68.91-39.78a22.73,22.73,0,0,1,22.71,0l68.91,39.78A22.77,22.77,0,0,1,1497.65,1472.84ZM1424.78,451.91A53.16,53.16,0,0,1,1451.29,406l118.88-68.64a53.22,53.22,0,0,1,53,0L1742.07,406a53.15,53.15,0,0,1,26.5,45.91V589.19a53.15,53.15,0,0,1-26.5,45.91l-118.89,68.64a53.15,53.15,0,0,1-53,0L1451.29,635.1a53.16,53.16,0,0,1-26.51-45.91Zm-46.24,216a53.15,53.15,0,0,1,53,0l118.89,68.64a53.15,53.15,0,0,1,26.5,45.91V919.76a53.15,53.15,0,0,1-26.5,45.91l-118.89,68.64a53.16,53.16,0,0,1-48.92,2.1c-1.37-.89-2.76-1.76-4.18-2.58l-118.89-68.64c-1.34-.78-2.71-1.5-4.08-2.21a53.17,53.17,0,0,1-22.33-43.22V782.49a53.16,53.16,0,0,1,26.51-45.91Zm-311.9-207.47a44,44,0,0,1,21.92-38l103.75-59.91a44,44,0,0,1,43.84,0l103.75,59.91a44,44,0,0,1,21.92,38v119.8a44,44,0,0,1-21.92,38l-103.75,59.9a44,44,0,0,1-43.84,0l-103.75-59.9a44,44,0,0,1-21.92-38Zm-24.56,789.6V1112.79a53.16,53.16,0,0,1,26.51-45.91l118.88-68.64a53.15,53.15,0,0,1,53,0l118.89,68.64a53.15,53.15,0,0,1,26.5,45.91v137.28a53.14,53.14,0,0,1-26.5,45.9l-118.89,68.64a53.15,53.15,0,0,1-53,0L1068.59,1296A53.15,53.15,0,0,1,1042.08,1250.07Zm154.5,714.6-88.85-51.3a34.91,34.91,0,0,1-17.4-30.14V1780.64a34.9,34.9,0,0,1,17.4-30.14l88.85-51.3a34.88,34.88,0,0,1,34.8,0l88.85,51.3a34.9,34.9,0,0,1,17.4,30.14v102.59a34.91,34.91,0,0,1-17.4,30.14l-88.85,51.3A34.93,34.93,0,0,1,1196.58,1964.67Zm330.93,247.64a34.63,34.63,0,0,1-17.27,29.92l-88.44,51.06a34.66,34.66,0,0,1-34.55,0l-88.44-51.06a34.65,34.65,0,0,1-17.27-29.92V2110.19a34.64,34.64,0,0,1,17.27-29.92l88.44-51.06a34.61,34.61,0,0,1,34.55,0l88.44,51.06a34.62,34.62,0,0,1,17.27,29.92Zm100.64-351.42-30.33,17.52-30.33-17.52v-35l30.33-17.51,30.33,17.51ZM1813.58,6.61A53,53,0,0,0,1794.09,0H1920V68.05Z"/>',
					'square'    => '<path d="M1864.72,1098.91,1785.26,1053a33.58,33.58,0,0,1-16.74-29V932.3a33.58,33.58,0,0,1,16.74-29l79.46-45.87a33.58,33.58,0,0,1,33.48,0L1920,870V560l-25.61,14.78a28.2,28.2,0,0,1-28.1,0L1795.72,534a28.19,28.19,0,0,1-14-24.34V428.18a28.19,28.19,0,0,1,14-24.34l70.57-40.74a28.2,28.2,0,0,1,28.1,0L1920,377.89V0H1718.91V12.52a40.94,40.94,0,0,1-20.41,35.36l-91.57,52.87a41,41,0,0,1-37.74,1.59q-1.31-.84-2.64-1.62L1475,47.86c-1-.61-2.1-1.17-3.17-1.71a41,41,0,0,1-17.7-33.63V0h-29.77V12.38a41,41,0,0,1-20.42,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0L1180,47.74a40.94,40.94,0,0,1-20.41-35.36V0H0V1920H1920V1086.33l-21.8,12.58A33.58,33.58,0,0,1,1864.72,1098.91Zm-18.17-463.22A41,41,0,0,1,1867,671.05V776.79a41,41,0,0,1-20.42,35.36L1755,865a40.93,40.93,0,0,1-39.36.79c-.45-.27-.89-.55-1.35-.81l-91.57-52.87c-.48-.28-1-.54-1.47-.81a40.93,40.93,0,0,1-19.06-34.52V671.05a40.94,40.94,0,0,1,20.41-35.36l91.57-52.87a41,41,0,0,1,40.83,0ZM1679.4,192.34a14.76,14.76,0,0,1,7.35-12.73l38.52-22.24a14.76,14.76,0,0,1,14.7,0l38.52,22.24a14.75,14.75,0,0,1,7.34,12.73v44.48a14.75,14.75,0,0,1-7.34,12.73L1740,271.79a14.78,14.78,0,0,1-14.7,0l-38.52-22.24a14.76,14.76,0,0,1-7.35-12.73Zm-92.56,130.27a40.74,40.74,0,0,1,20.41,5.46l91.57,52.86a40.93,40.93,0,0,1,20.42,35.36V522a40.93,40.93,0,0,1-20.42,35.36l-91.57,52.87a40.92,40.92,0,0,1-37.68,1.61c-1-.61-1.91-1.21-2.9-1.77l-91.57-52.87c-1-.6-2.08-1.16-3.14-1.7a40.94,40.94,0,0,1-17.52-33.5V416.29a40.93,40.93,0,0,1,19.07-34.52q.73-.39,1.47-.81l91.57-52.87c.45-.26.89-.53,1.33-.8A40.9,40.9,0,0,1,1586.84,322.61ZM1328,812a41,41,0,0,1-20.42-35.36V670.91A41,41,0,0,1,1328,635.55l91.57-52.87a41,41,0,0,1,40.83,0L1552,635.55a40.94,40.94,0,0,1,20.41,35.36V776.65A40.94,40.94,0,0,1,1552,812l-91.57,52.87a40.94,40.94,0,0,1-40.83,0Zm35.58,135.88v61.29a17.53,17.53,0,0,1-8.75,15.15L1301.76,1055a17.56,17.56,0,0,1-17.49,0l-53.08-30.65a17.54,17.54,0,0,1-8.74-15.15V947.89a17.55,17.55,0,0,1,8.74-15.15l53.08-30.64a17.51,17.51,0,0,1,17.49,0l53.08,30.64A17.54,17.54,0,0,1,1363.59,947.89Zm-56.13-786.35a41,41,0,0,1,20.42-35.36l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87a40.94,40.94,0,0,1,20.41,35.36V267.27a41,41,0,0,1-20.41,35.37l-91.57,52.86a40.94,40.94,0,0,1-40.83,0l-91.57-52.86a41,41,0,0,1-20.42-35.37Zm-35.61,166.39a41,41,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V521.89a41,41,0,0,1-20.42,35.36l-91.57,52.87a41,41,0,0,1-37.68,1.62c-1.06-.69-2.13-1.36-3.22-2l-91.57-52.87c-1-.57-2-1.12-3-1.64a41,41,0,0,1-17.31-33.35V416.16a41,41,0,0,1,20.42-35.36Zm-240.24-159.8a33.86,33.86,0,0,1,16.88-29.24l79.92-46.14a33.84,33.84,0,0,1,33.76,0l79.92,46.14A33.86,33.86,0,0,1,1259,168.13v92.28a33.86,33.86,0,0,1-16.88,29.24l-79.92,46.14a33.86,33.86,0,0,1-33.76,0l-79.92-46.14a33.86,33.86,0,0,1-16.88-29.24ZM1012.7,776.3V670.57a40.94,40.94,0,0,1,20.41-35.36l91.57-52.87a40.9,40.9,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V776.3a41,41,0,0,1-20.42,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0l-91.57-52.87A40.94,40.94,0,0,1,1012.7,776.3Zm119,550.41-68.44-39.51a26.87,26.87,0,0,1-13.4-23.21v-79a26.87,26.87,0,0,1,13.4-23.21l68.44-39.51a26.87,26.87,0,0,1,26.8,0l68.43,39.51a26.88,26.88,0,0,1,13.41,23.21v79a26.88,26.88,0,0,1-13.41,23.21l-68.43,39.51A26.88,26.88,0,0,1,1131.7,1326.71Zm254.89,190.74a26.68,26.68,0,0,1-13.3,23l-68.12,39.33a26.72,26.72,0,0,1-26.61,0l-68.12-39.33a26.69,26.69,0,0,1-13.31-23v-78.66a26.68,26.68,0,0,1,13.31-23l68.12-39.33a26.71,26.71,0,0,1,26.61,0l68.12,39.33a26.67,26.67,0,0,1,13.3,23Zm77.52-270.67-23.36,13.49-23.37-13.49v-27l23.37-13.48,23.36,13.48Zm103.07-127-91.57-52.87a40.93,40.93,0,0,1-20.42-35.36V925.81a40.93,40.93,0,0,1,20.42-35.36l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87A40.94,40.94,0,0,1,1720,925.81v105.73a40.94,40.94,0,0,1-20.41,35.36L1608,1119.77A40.94,40.94,0,0,1,1567.18,1119.77Zm300.54,166.53a40.94,40.94,0,0,1-20.41,35.36l-91.57,52.87a40.94,40.94,0,0,1-40.83,0l-91.57-52.87a40.93,40.93,0,0,1-20.42-35.36V1180.56a40.93,40.93,0,0,1,20.42-35.36l91.56-52.87a41,41,0,0,1,40.84,0l91.57,52.87a40.94,40.94,0,0,1,20.41,35.36Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1180.28,380.8l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V521.89a41,41,0,0,1-20.42,35.36l-91.57,52.87a41,41,0,0,1-37.68,1.62c-1.06-.69-2.13-1.36-3.22-2l-91.57-52.87c-1-.57-2-1.12-3-1.64a41,41,0,0,1-17.31-33.35V416.16A41,41,0,0,1,1180.28,380.8Zm193,1035-68.12-39.33a26.71,26.71,0,0,0-26.61,0l-68.12,39.33a26.68,26.68,0,0,0-13.31,23V1440h189.46v-1.21A26.67,26.67,0,0,0,1373.29,1415.75ZM1566.55,328.09,1475,381q-.74.42-1.47.81a40.93,40.93,0,0,0-19.07,34.52V522a40.94,40.94,0,0,0,17.52,33.5c1.06.54,2.11,1.1,3.14,1.7l91.57,52.87c1,.56,1.95,1.16,2.9,1.77a40.92,40.92,0,0,0,37.68-1.61l91.57-52.87A40.93,40.93,0,0,0,1719.24,522V416.29a40.93,40.93,0,0,0-20.42-35.36l-91.57-52.86a40.81,40.81,0,0,0-39.37-.78C1567.44,327.56,1567,327.83,1566.55,328.09Zm119.8-78.24,38.86,22.44a14.86,14.86,0,0,0,14.82,0l38.86-22.44A14.87,14.87,0,0,0,1786.3,237V192.14a14.87,14.87,0,0,0-7.41-12.83L1740,156.87a14.86,14.86,0,0,0-14.82,0l-38.86,22.44a14.87,14.87,0,0,0-7.41,12.83V237A14.87,14.87,0,0,0,1686.35,249.85Zm194,109.5a28.15,28.15,0,0,0-14,3.75l-70.57,40.74a28.19,28.19,0,0,0-14,24.34v81.48a28.19,28.19,0,0,0,14,24.34l70.57,40.74a28.2,28.2,0,0,0,28.1,0L1920,560V377.89l-25.61-14.79A28.1,28.1,0,0,0,1880.34,359.35ZM1460.41,864.88,1552,812a40.94,40.94,0,0,0,20.41-35.36V670.91A40.94,40.94,0,0,0,1552,635.55l-91.57-52.87a41,41,0,0,0-40.83,0L1328,635.55a41,41,0,0,0-20.42,35.36V776.65A41,41,0,0,0,1328,812l91.57,52.87A40.94,40.94,0,0,0,1460.41,864.88Zm-294.9-.35,91.57-52.87a41,41,0,0,0,20.42-35.36V670.57a41,41,0,0,0-20.42-35.36l-91.57-52.87a40.9,40.9,0,0,0-40.83,0l-91.57,52.87a40.94,40.94,0,0,0-20.41,35.36V776.3a40.94,40.94,0,0,0,20.41,35.36l91.57,52.87A40.94,40.94,0,0,0,1165.51,864.53Zm61.42,297.22-68.43-39.51a26.87,26.87,0,0,0-26.8,0l-68.44,39.51a26.87,26.87,0,0,0-13.4,23.21v79a26.87,26.87,0,0,0,13.4,23.21l68.44,39.51a26.88,26.88,0,0,0,26.8,0l68.43-39.51a26.88,26.88,0,0,0,13.41-23.21v-79A26.88,26.88,0,0,0,1226.93,1161.75Zm507.64-584.38a40.9,40.9,0,0,0-20.42,5.45l-91.57,52.87a40.94,40.94,0,0,0-20.41,35.36V776.79a40.93,40.93,0,0,0,19.06,34.52c.5.27,1,.53,1.47.81L1714.27,865c.46.26.9.54,1.35.81A40.93,40.93,0,0,0,1755,865l91.57-52.86A41,41,0,0,0,1867,776.79V671.05a41,41,0,0,0-20.42-35.36L1755,582.82A40.83,40.83,0,0,0,1734.57,577.37ZM1354.84,932.74l-53.08-30.64a17.51,17.51,0,0,0-17.49,0l-53.08,30.64a17.55,17.55,0,0,0-8.74,15.15v61.29a17.54,17.54,0,0,0,8.74,15.15l53.08,30.65a17.56,17.56,0,0,0,17.49,0l53.08-30.65a17.53,17.53,0,0,0,8.75-15.15V947.89A17.54,17.54,0,0,0,1354.84,932.74Zm344.74,134.16a40.94,40.94,0,0,0,20.41-35.36V925.81a40.94,40.94,0,0,0-20.41-35.36L1608,837.58a41,41,0,0,0-40.83,0l-91.57,52.87a40.93,40.93,0,0,0-20.42,35.36v105.73a40.93,40.93,0,0,0,20.42,35.36l91.57,52.87a40.94,40.94,0,0,0,40.83,0ZM1898.2,857.43a33.58,33.58,0,0,0-33.48,0l-79.46,45.87a33.58,33.58,0,0,0-16.74,29V1024a33.58,33.58,0,0,0,16.74,29l79.46,45.87a33.58,33.58,0,0,0,33.48,0l21.8-12.58V870ZM1417.38,1219.8v27l23.37,13.49,23.36-13.49v-27l-23.36-13.48Zm429.93-74.6-91.57-52.87a41,41,0,0,0-40.84,0l-91.56,52.87a40.93,40.93,0,0,0-20.42,35.36V1286.3a40.93,40.93,0,0,0,20.42,35.36l91.57,52.87a40.94,40.94,0,0,0,40.83,0l91.57-52.87a40.94,40.94,0,0,0,20.41-35.36V1180.56A40.94,40.94,0,0,0,1847.31,1145.2ZM1180,47.74l91.57,52.87a40.94,40.94,0,0,0,40.83,0l91.57-52.87a41,41,0,0,0,20.42-35.36V0h-264.8V12.38A40.94,40.94,0,0,0,1180,47.74Zm291.86-1.59c1.06.54,2.12,1.1,3.17,1.71l91.57,52.86q1.34.78,2.64,1.62a41,41,0,0,0,37.74-1.59l91.57-52.87a40.94,40.94,0,0,0,20.41-35.36V0h-264.8V12.52A41,41,0,0,0,1471.81,46.15Zm-423.32,243.5,79.92,46.14a33.86,33.86,0,0,0,33.76,0l79.92-46.14A33.86,33.86,0,0,0,1259,260.41V168.13a33.86,33.86,0,0,0-16.88-29.24l-79.92-46.14a33.84,33.84,0,0,0-33.76,0l-79.92,46.14a33.86,33.86,0,0,0-16.88,29.24v92.28A33.86,33.86,0,0,0,1048.49,289.65Zm279.39,13,91.57,52.86a40.94,40.94,0,0,0,40.83,0l91.57-52.86a41,41,0,0,0,20.41-35.37V161.54a40.94,40.94,0,0,0-20.41-35.36l-91.57-52.87a41,41,0,0,0-40.83,0l-91.57,52.87a41,41,0,0,0-20.42,35.36V267.27A41,41,0,0,0,1327.88,302.64Z"/>',
					'portrait'  => '<path d="M1259.66,736.58l118.88-68.64a53.15,53.15,0,0,1,53,0l118.89,68.64a53.15,53.15,0,0,1,26.5,45.91V919.76a53.15,53.15,0,0,1-26.5,45.91l-118.89,68.64a53.16,53.16,0,0,1-48.92,2.1c-1.37-.89-2.76-1.76-4.18-2.58l-118.89-68.64c-1.34-.78-2.71-1.5-4.08-2.21a53.17,53.17,0,0,1-22.33-43.22V782.49A53.16,53.16,0,0,1,1259.66,736.58Zm250.58,1343.69-88.44-51.06a34.61,34.61,0,0,0-34.55,0l-88.44,51.06a34.64,34.64,0,0,0-17.27,29.92v102.12a34.65,34.65,0,0,0,17.27,29.92l88.44,51.06a34.66,34.66,0,0,0,34.55,0l88.44-51.06a34.63,34.63,0,0,0,17.27-29.92V2110.19A34.62,34.62,0,0,0,1510.24,2080.27ZM1787.5,661a53.12,53.12,0,0,0-24.61,6.06c-.58.35-1.15.71-1.74,1l-118.89,68.64c-.73.42-1.48.83-2.23,1.23a53.2,53.2,0,0,0-24.43,44.65V919.94a53.16,53.16,0,0,0,22.64,43.44q2.12,1.08,4.19,2.26l118.89,68.64q1.9,1.11,3.75,2.31a53.18,53.18,0,0,0,48.93-2.1l106-61.2v-244l-106-61.19A53,53,0,0,0,1787.5,661ZM1570.34,998.69l-118.89,68.64a53.15,53.15,0,0,0-26.5,45.91v137.28a53.14,53.14,0,0,0,26.5,45.9l118.89,68.64a53.15,53.15,0,0,0,53,0l118.89-68.64a53.16,53.16,0,0,0,26.5-45.9V1113.24a53.17,53.17,0,0,0-26.5-45.91l-118.89-68.64a53.15,53.15,0,0,0-53,0Zm-329.86,365.92L1359.37,1296a53.14,53.14,0,0,0,26.5-45.9V1112.79a53.15,53.15,0,0,0-26.5-45.91l-118.89-68.64a53.15,53.15,0,0,0-53,0l-118.88,68.64a53.16,53.16,0,0,0-26.51,45.91v137.28a53.15,53.15,0,0,0,26.51,45.9l118.88,68.64A53.15,53.15,0,0,0,1240.48,1364.61Zm97.15,518.62V1780.64a34.9,34.9,0,0,0-17.4-30.14l-88.85-51.3a34.88,34.88,0,0,0-34.8,0l-88.85,51.3a34.9,34.9,0,0,0-17.4,30.14v102.59a34.91,34.91,0,0,0,17.4,30.14l88.85,51.3a34.93,34.93,0,0,0,34.8,0l88.85-51.3A34.91,34.91,0,0,0,1337.63,1883.23Zm469.77-769.81v137.27a53.17,53.17,0,0,0,24.42,44.64c.75.4,1.5.82,2.24,1.24l85.94,49.62V1017.8l-86.1,49.71A53.15,53.15,0,0,0,1807.4,1113.42Zm-390,300a22.73,22.73,0,0,0-22.71,0l-68.91,39.78a22.77,22.77,0,0,0-11.36,19.67v79.58a22.76,22.76,0,0,0,11.36,19.66l68.91,39.79a22.74,22.74,0,0,0,22.71,0l68.91-39.79a22.76,22.76,0,0,0,11.36-19.66v-79.58a22.77,22.77,0,0,0-11.36-19.67Zm371.1-90.85a53,53,0,0,0-26.51,7.08l-118.89,68.64a53.15,53.15,0,0,0-26.5,45.91v137.28a53.15,53.15,0,0,0,26.5,45.91L1762,1696a53.2,53.2,0,0,0,53,0l105-60.64V1390.25l-105-60.63A53,53,0,0,0,1788.48,1322.54Zm-221,503.33v35l30.33,17.52,30.33-17.52v-35l-30.33-17.51ZM1834.88,1729a53.15,53.15,0,0,0-26.5,45.91V1912.2a53.15,53.15,0,0,0,26.5,45.91l85.12,49.14V1679.87ZM1259.23,75.07a53.15,53.15,0,0,0-26.5,45.91V258.26a53.15,53.15,0,0,0,26.5,45.91l118.89,68.64a53.18,53.18,0,0,0,53,0L1550,304.17a53.16,53.16,0,0,0,26.51-45.91V121A53.16,53.16,0,0,0,1550,75.07L1431.13,6.43A52.73,52.73,0,0,0,1412.74,0h-16.23a52.73,52.73,0,0,0-18.39,6.43Zm382.45.18a53.16,53.16,0,0,0-26.51,45.91V258.44a53.17,53.17,0,0,0,22.91,43.62c1.41.71,2.81,1.46,4.18,2.26L1761.15,373c1.17.68,2.31,1.38,3.43,2.1a53.14,53.14,0,0,0,49-2.07L1920,311.54V68.05L1813.58,6.61A53,53,0,0,0,1794.09,0h-14a52.86,52.86,0,0,0-19.49,6.61Zm-553.12,543,103.75,59.9a44,44,0,0,0,43.84,0l103.75-59.9a44,44,0,0,0,21.92-38V460.47a44,44,0,0,0-21.92-38L1236.15,362.6a44,44,0,0,0-43.84,0l-103.75,59.91a44,44,0,0,0-21.92,38v119.8A44,44,0,0,0,1088.56,618.24Zm362.73,16.86,118.88,68.64a53.15,53.15,0,0,0,53,0l118.89-68.64a53.15,53.15,0,0,0,26.5-45.91V451.91a53.15,53.15,0,0,0-26.5-45.91l-118.89-68.64a53.22,53.22,0,0,0-53,0L1451.29,406a53.16,53.16,0,0,0-26.51,45.91V589.19A53.16,53.16,0,0,0,1451.29,635.1Z"/>',
					'square'    => '<path d="M1180.28,380.8l91.57-52.87a41,41,0,0,1,40.83,0l91.57,52.87a41,41,0,0,1,20.42,35.36V521.89a41,41,0,0,1-20.42,35.36l-91.57,52.87a41,41,0,0,1-37.68,1.62c-1.06-.69-2.13-1.36-3.22-2l-91.57-52.87c-1-.57-2-1.12-3-1.64a41,41,0,0,1-17.31-33.35V416.16A41,41,0,0,1,1180.28,380.8Zm193,1035-68.12-39.33a26.71,26.71,0,0,0-26.61,0l-68.12,39.33a26.68,26.68,0,0,0-13.31,23v78.66a26.69,26.69,0,0,0,13.31,23l68.12,39.33a26.72,26.72,0,0,0,26.61,0l68.12-39.33a26.68,26.68,0,0,0,13.3-23v-78.66A26.67,26.67,0,0,0,1373.29,1415.75ZM1566.55,328.09,1475,381q-.74.42-1.47.81a40.93,40.93,0,0,0-19.07,34.52V522a40.94,40.94,0,0,0,17.52,33.5c1.06.54,2.11,1.1,3.14,1.7l91.57,52.87c1,.56,1.95,1.16,2.9,1.77a40.92,40.92,0,0,0,37.68-1.61l91.57-52.87A40.93,40.93,0,0,0,1719.24,522V416.29a40.93,40.93,0,0,0-20.42-35.36l-91.57-52.86a40.81,40.81,0,0,0-39.37-.78C1567.44,327.56,1567,327.83,1566.55,328.09Zm120.2-78.54,38.52,22.24a14.78,14.78,0,0,0,14.7,0l38.52-22.24a14.75,14.75,0,0,0,7.34-12.73V192.34a14.75,14.75,0,0,0-7.34-12.73L1740,157.37a14.76,14.76,0,0,0-14.7,0l-38.52,22.24a14.76,14.76,0,0,0-7.35,12.73v44.48A14.76,14.76,0,0,0,1686.75,249.55Zm193.59,109.8a28.15,28.15,0,0,0-14,3.75l-70.57,40.74a28.19,28.19,0,0,0-14,24.34v81.48a28.19,28.19,0,0,0,14,24.34l70.57,40.74a28.2,28.2,0,0,0,28.1,0L1920,560V377.89l-25.61-14.79A28.1,28.1,0,0,0,1880.34,359.35ZM1460.41,864.88,1552,812a40.94,40.94,0,0,0,20.41-35.36V670.91A40.94,40.94,0,0,0,1552,635.55l-91.57-52.87a41,41,0,0,0-40.83,0L1328,635.55a41,41,0,0,0-20.42,35.36V776.65A41,41,0,0,0,1328,812l91.57,52.87A40.94,40.94,0,0,0,1460.41,864.88Zm-294.9-.35,91.57-52.87a41,41,0,0,0,20.42-35.36V670.57a41,41,0,0,0-20.42-35.36l-91.57-52.87a40.9,40.9,0,0,0-40.83,0l-91.57,52.87a40.94,40.94,0,0,0-20.41,35.36V776.3a40.94,40.94,0,0,0,20.41,35.36l91.57,52.87A40.94,40.94,0,0,0,1165.51,864.53ZM1240.34,1264v-79a26.88,26.88,0,0,0-13.41-23.21l-68.43-39.51a26.87,26.87,0,0,0-26.8,0l-68.44,39.51a26.87,26.87,0,0,0-13.4,23.21v79a26.87,26.87,0,0,0,13.4,23.21l68.44,39.51a26.88,26.88,0,0,0,26.8,0l68.43-39.51A26.88,26.88,0,0,0,1240.34,1264Zm494.23-686.62a40.9,40.9,0,0,0-20.42,5.45l-91.57,52.87a40.94,40.94,0,0,0-20.41,35.36V776.79a40.93,40.93,0,0,0,19.06,34.52c.5.27,1,.53,1.47.81L1714.27,865c.46.26.9.54,1.35.81A40.93,40.93,0,0,0,1755,865l91.57-52.86A41,41,0,0,0,1867,776.79V671.05a41,41,0,0,0-20.42-35.36L1755,582.82A40.83,40.83,0,0,0,1734.57,577.37ZM1301.76,902.1a17.51,17.51,0,0,0-17.49,0l-53.08,30.64a17.55,17.55,0,0,0-8.74,15.15v61.29a17.54,17.54,0,0,0,8.74,15.15l53.08,30.65a17.56,17.56,0,0,0,17.49,0l53.08-30.65a17.53,17.53,0,0,0,8.75-15.15V947.89a17.54,17.54,0,0,0-8.75-15.15Zm397.82,164.8a40.94,40.94,0,0,0,20.41-35.36V925.81a40.94,40.94,0,0,0-20.41-35.36L1608,837.58a41,41,0,0,0-40.83,0l-91.57,52.87a40.93,40.93,0,0,0-20.42,35.36v105.73a40.93,40.93,0,0,0,20.42,35.36l91.57,52.87a40.94,40.94,0,0,0,40.83,0ZM1898.2,857.43a33.58,33.58,0,0,0-33.48,0l-79.46,45.87a33.58,33.58,0,0,0-16.74,29V1024a33.58,33.58,0,0,0,16.74,29l79.46,45.87a33.58,33.58,0,0,0,33.48,0l21.8-12.58V870ZM1417.38,1219.8v27l23.37,13.49,23.36-13.49v-27l-23.36-13.48Zm429.93-74.6-91.57-52.87a41,41,0,0,0-40.84,0l-91.56,52.87a40.93,40.93,0,0,0-20.42,35.36V1286.3a40.93,40.93,0,0,0,20.42,35.36l91.57,52.87a40.94,40.94,0,0,0,40.83,0l91.57-52.87a40.94,40.94,0,0,0,20.41-35.36V1180.56A40.94,40.94,0,0,0,1847.31,1145.2ZM1180,47.74l91.57,52.87a40.94,40.94,0,0,0,40.83,0l91.57-52.87a41,41,0,0,0,20.42-35.36V0h-264.8V12.38A40.94,40.94,0,0,0,1180,47.74Zm291.86-1.59c1.07.54,2.12,1.1,3.17,1.71l91.57,52.86q1.34.78,2.64,1.62a41,41,0,0,0,37.74-1.59l91.57-52.87a40.94,40.94,0,0,0,20.41-35.36V0h-264.8V12.52A41,41,0,0,0,1471.81,46.15Zm-423.32,243.5,79.92,46.14a33.86,33.86,0,0,0,33.76,0l79.92-46.14A33.86,33.86,0,0,0,1259,260.41V168.13a33.86,33.86,0,0,0-16.88-29.24l-79.92-46.14a33.84,33.84,0,0,0-33.76,0l-79.92,46.14a33.86,33.86,0,0,0-16.88,29.24v92.28A33.86,33.86,0,0,0,1048.49,289.65Zm279.39,13,91.57,52.86a40.94,40.94,0,0,0,40.83,0l91.57-52.86a41,41,0,0,0,20.41-35.37V161.54a40.94,40.94,0,0,0-20.41-35.36l-91.57-52.87a41,41,0,0,0-40.83,0l-91.57,52.87a41,41,0,0,0-20.42,35.36V267.27A41,41,0,0,0,1327.88,302.64Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M1098.91,55.28,1053,134.74a33.58,33.58,0,0,1-29,16.74H932.3a33.58,33.58,0,0,1-29-16.74L857.43,55.28a33.58,33.58,0,0,1,0-33.48L870,0H560l14.78,25.61a28.2,28.2,0,0,1,0,28.1L534,124.28a28.19,28.19,0,0,1-24.34,14H428.18a28.19,28.19,0,0,1-24.34-14L363.1,53.71a28.2,28.2,0,0,1,0-28.1L377.89,0H0V201.09H12.52A40.94,40.94,0,0,1,47.88,221.5l52.87,91.57a41,41,0,0,1,1.59,37.74q-.84,1.31-1.62,2.64L47.86,445c-.61,1.05-1.17,2.1-1.71,3.17a41,41,0,0,1-33.63,17.7H0v29.77H12.38a41,41,0,0,1,35.36,20.42l52.87,91.57a40.94,40.94,0,0,1,0,40.83L47.74,740.05a40.94,40.94,0,0,1-35.36,20.41H0V1440H1920V0H1086.33l12.58,21.8A33.58,33.58,0,0,1,1098.91,55.28ZM635.69,73.45A41,41,0,0,1,671.05,53H776.79a41,41,0,0,1,35.36,20.42L865,165a40.93,40.93,0,0,1,.79,39.36c-.27.45-.55.89-.81,1.35L812.12,297.3c-.28.48-.54,1-.81,1.47a40.93,40.93,0,0,1-34.52,19.06H671.05a40.94,40.94,0,0,1-35.36-20.41l-52.87-91.57a41,41,0,0,1,0-40.83ZM192.34,240.6a14.76,14.76,0,0,1-12.73-7.35l-22.24-38.52a14.76,14.76,0,0,1,0-14.7l22.24-38.52a14.75,14.75,0,0,1,12.73-7.34h44.48a14.75,14.75,0,0,1,12.73,7.34L271.79,180a14.78,14.78,0,0,1,0,14.7l-22.24,38.52a14.76,14.76,0,0,1-12.73,7.35Zm130.27,92.56a40.74,40.74,0,0,1,5.46-20.41l52.86-91.57a40.93,40.93,0,0,1,35.36-20.42H522a40.93,40.93,0,0,1,35.36,20.42l52.87,91.57a40.92,40.92,0,0,1,1.61,37.68c-.61.95-1.21,1.91-1.77,2.9L557.23,444.9c-.6,1-1.16,2.08-1.7,3.14A40.94,40.94,0,0,1,522,465.56H416.29a40.93,40.93,0,0,1-34.52-19.07q-.39-.74-.81-1.47l-52.87-91.57c-.26-.45-.53-.89-.8-1.33A40.9,40.9,0,0,1,322.61,333.16ZM812,592a41,41,0,0,1-35.36,20.42H670.91A41,41,0,0,1,635.55,592l-52.87-91.57a41,41,0,0,1,0-40.83L635.55,368a40.94,40.94,0,0,1,35.36-20.41H776.65A40.94,40.94,0,0,1,812,368l52.87,91.57a40.94,40.94,0,0,1,0,40.83Zm135.88-35.58h61.29a17.53,17.53,0,0,1,15.15,8.75L1055,618.24a17.56,17.56,0,0,1,0,17.49l-30.65,53.08a17.54,17.54,0,0,1-15.15,8.74H947.89a17.55,17.55,0,0,1-15.15-8.74L902.1,635.73a17.51,17.51,0,0,1,0-17.49l30.64-53.08A17.54,17.54,0,0,1,947.89,556.41ZM161.54,612.54a41,41,0,0,1-35.36-20.42L73.31,500.55a41,41,0,0,1,0-40.83l52.87-91.57a40.94,40.94,0,0,1,35.36-20.41H267.27a41,41,0,0,1,35.37,20.41l52.86,91.57a40.94,40.94,0,0,1,0,40.83l-52.86,91.57a41,41,0,0,1-35.37,20.42Zm166.39,35.61a41,41,0,0,1,0-40.83l52.87-91.57a41,41,0,0,1,35.36-20.42H521.89a41,41,0,0,1,35.36,20.42l52.87,91.57A41,41,0,0,1,611.74,645c-.69,1.06-1.36,2.13-2,3.22l-52.87,91.57c-.57,1-1.12,2-1.64,3a41,41,0,0,1-33.35,17.31H416.16a41,41,0,0,1-35.36-20.42ZM168.13,888.39a33.86,33.86,0,0,1-29.24-16.88L92.75,791.59a33.84,33.84,0,0,1,0-33.76l46.14-79.92A33.86,33.86,0,0,1,168.13,661h92.28a33.86,33.86,0,0,1,29.24,16.88l46.14,79.92a33.86,33.86,0,0,1,0,33.76l-46.14,79.92a33.86,33.86,0,0,1-29.24,16.88ZM776.3,907.3H670.57a40.94,40.94,0,0,1-35.36-20.41l-52.87-91.57a40.9,40.9,0,0,1,0-40.83l52.87-91.57a41,41,0,0,1,35.36-20.42H776.3a41,41,0,0,1,35.36,20.42l52.87,91.57a40.94,40.94,0,0,1,0,40.83l-52.87,91.57A40.94,40.94,0,0,1,776.3,907.3Zm550.41-119-39.51,68.44a26.87,26.87,0,0,1-23.21,13.4h-79a26.87,26.87,0,0,1-23.21-13.4l-39.51-68.44a26.87,26.87,0,0,1,0-26.8l39.51-68.43A26.88,26.88,0,0,1,1185,679.66h79a26.88,26.88,0,0,1,23.21,13.41l39.51,68.43A26.88,26.88,0,0,1,1326.71,788.3Zm190.74-254.89a26.68,26.68,0,0,1,23,13.3l39.33,68.12a26.72,26.72,0,0,1,0,26.61l-39.33,68.12a26.69,26.69,0,0,1-23,13.31h-78.66a26.68,26.68,0,0,1-23-13.31l-39.33-68.12a26.71,26.71,0,0,1,0-26.61l39.33-68.12a26.67,26.67,0,0,1,23-13.3Zm-270.67-77.52,13.49,23.36-13.49,23.37h-27l-13.48-23.37,13.48-23.36Zm-127-103.07-52.87,91.57a40.93,40.93,0,0,1-35.36,20.42H925.81a40.93,40.93,0,0,1-35.36-20.42l-52.87-91.57a41,41,0,0,1,0-40.83l52.87-91.57A40.94,40.94,0,0,1,925.81,200h105.73a40.94,40.94,0,0,1,35.36,20.41L1119.77,312A40.94,40.94,0,0,1,1119.77,352.82ZM1286.3,52.28a40.94,40.94,0,0,1,35.36,20.41l52.87,91.57a40.94,40.94,0,0,1,0,40.83l-52.87,91.57a40.93,40.93,0,0,1-35.36,20.42H1180.56a40.93,40.93,0,0,1-35.36-20.42l-52.87-91.56a41,41,0,0,1,0-40.84l52.87-91.57a40.94,40.94,0,0,1,35.36-20.41Z"/>',
					'portrait'  => '<path d="M1849.45,926.93l-51.38-89a34.87,34.87,0,0,1,0-34.76l51.38-89a34.87,34.87,0,0,1,30.11-17.38H1920V0H1419.11l16.44,28.48a43.85,43.85,0,0,1,0,43.74L1375.63,176a43.87,43.87,0,0,1-37.88,21.87H1217.9A43.86,43.86,0,0,1,1180,176L1120.09,72.22a43.87,43.87,0,0,1,0-43.74L1136.53,0h-405l19.32,33.45a36.84,36.84,0,0,1,0,36.71l-53.23,92.19A36.79,36.79,0,0,1,665.8,180.7H559.35a36.79,36.79,0,0,1-31.79-18.35L474.33,70.16a36.83,36.83,0,0,1,0-36.71L493.65,0H0V262.69H16.35a53.5,53.5,0,0,1,46.2,26.67L131.61,409a53.52,53.52,0,0,1,2.08,49.3c-.72,1.13-1.43,2.28-2.11,3.45L62.52,581.35c-.79,1.37-1.53,2.75-2.24,4.14a53.48,53.48,0,0,1-43.93,23.12H0V647.5H16.17a53.5,53.5,0,0,1,46.2,26.67l69.06,119.62a53.48,53.48,0,0,1,0,53.34L62.37,966.75a53.5,53.5,0,0,1-46.2,26.67H0V2560H1920V944.31h-40.44A34.87,34.87,0,0,1,1849.45,926.93ZM1427,214.58,1496,95a53.5,53.5,0,0,1,46.2-26.67h138.12A53.5,53.5,0,0,1,1726.54,95l69.06,119.62a53.48,53.48,0,0,1,0,53.34l-69.06,119.62a53.5,53.5,0,0,1-46.2,26.67H1542.22a53.5,53.5,0,0,1-46.2-26.67L1427,267.92a53.51,53.51,0,0,1,0-53.34Zm219.38,411.49-17.62,30.52h-35.24l-17.62-30.52,17.62-30.52h35.24Zm-885-410.5L830.43,96a53.49,53.49,0,0,1,46.19-26.67h138.13A53.49,53.49,0,0,1,1060.94,96L1130,215.57a53.46,53.46,0,0,1,1,51.43c-.35.58-.71,1.16-1,1.75l-69.06,119.62c-.37.63-.72,1.28-1.07,1.92a53.48,53.48,0,0,1-45.09,24.91H876.62a53.49,53.49,0,0,1-46.19-26.67L761.36,268.91a53.51,53.51,0,0,1,0-53.34Zm-332.79,193,69.06-119.62a53.49,53.49,0,0,1,46.19-26.67H682a53.49,53.49,0,0,1,46.19,26.67l69.07,119.62a53.49,53.49,0,0,1,2.1,49.24c-.79,1.24-1.57,2.49-2.32,3.77L727.93,581.18c-.78,1.36-1.51,2.73-2.22,4.11A53.49,53.49,0,0,1,682,608.18H543.82a53.45,53.45,0,0,1-45.09-24.91c-.35-.64-.7-1.28-1.07-1.92L428.6,461.73c-.34-.59-.7-1.16-1.05-1.74a53.36,53.36,0,0,1,1-51.44Zm-223-173.37,29.06-50.32a19.22,19.22,0,0,1,16.62-9.59h58.11A19.25,19.25,0,0,1,326,184.86l29.06,50.32a19.3,19.3,0,0,1,0,19.2L326,304.7a19.25,19.25,0,0,1-16.62,9.6H251.26a19.23,19.23,0,0,1-16.62-9.6l-29.06-50.32a19.28,19.28,0,0,1,0-19.2ZM95.77,653.89a53.51,53.51,0,0,1,0-53.34l69.06-119.62A53.49,53.49,0,0,1,211,454.26H349.15a53.47,53.47,0,0,1,46.19,26.67l69.07,119.62a53.5,53.5,0,0,1,0,53.34L395.34,773.51a53.47,53.47,0,0,1-46.19,26.67H211a53.49,53.49,0,0,1-46.19-26.67Zm342.88,380.2-60.27,104.39a44.23,44.23,0,0,1-38.2,22.06H219.63a44.21,44.21,0,0,1-38.19-22.06l-60.28-104.39a44.24,44.24,0,0,1,0-44.11l60.28-104.39a44.21,44.21,0,0,1,38.19-22.06H340.18a44.23,44.23,0,0,1,38.2,22.06L438.65,990A44.23,44.23,0,0,1,438.65,1034.09Zm286.68-63.7A53.5,53.5,0,0,1,681.77,993H543.64a53.49,53.49,0,0,1-46.19-26.67L428.39,846.7a53.43,53.43,0,0,1,0-53.33l69.06-119.62a53.49,53.49,0,0,1,46.19-26.67H681.77A53.49,53.49,0,0,1,728,673.75L797,793.37a53.45,53.45,0,0,1,2.12,49.22q-1.35,2.07-2.6,4.21L727.48,966.42C726.72,967.72,726,969.05,725.33,970.39Zm404,68.57-69.06,119.62a53.5,53.5,0,0,1-46.2,26.67H876a53.5,53.5,0,0,1-46.2-26.67L760.73,1039a53.51,53.51,0,0,1,0-53.34L829.79,866A53.5,53.5,0,0,1,876,839.33h138.12a53.5,53.5,0,0,1,46.2,26.67l69.06,119.62A53.48,53.48,0,0,1,1129.37,1039Zm.45-385.24-69.06,119.62A53.49,53.49,0,0,1,1014.57,800H876.44a53.49,53.49,0,0,1-46.19-26.67L761.18,653.72a53.51,53.51,0,0,1,0-53.34l69.07-119.62a53.49,53.49,0,0,1,46.19-26.67h138.13a53.49,53.49,0,0,1,46.19,26.67l69.06,119.62A53.48,53.48,0,0,1,1129.82,653.72Zm248.34,176.76-40,69.34a22.91,22.91,0,0,1-19.78,11.42h-80.07a22.92,22.92,0,0,1-19.79-11.42l-40-69.34a22.86,22.86,0,0,1,0-22.85l40-69.34a22.91,22.91,0,0,1,19.79-11.43h80.07a22.9,22.9,0,0,1,19.78,11.43l40,69.34A22.91,22.91,0,0,1,1378.16,830.48ZM1347.54,607.2H1209.42a53.47,53.47,0,0,1-46.19-26.67l-69.07-119.62a53.51,53.51,0,0,1,0-53.34L1163.23,288a53.47,53.47,0,0,1,46.19-26.67h138.12a53.5,53.5,0,0,1,46.2,26.67l69.06,119.62a53.48,53.48,0,0,1,0,53.34l-69.06,119.62A53.5,53.5,0,0,1,1347.54,607.2Zm385.59,422.59-51.61,89.4a35.11,35.11,0,0,1-30.32,17.51H1548a35.13,35.13,0,0,1-30.33-17.51l-51.61-89.4a35.08,35.08,0,0,1,0-35l51.61-89.4A35.13,35.13,0,0,1,1548,887.87H1651.2a35.11,35.11,0,0,1,30.32,17.51l51.61,89.4A35.08,35.08,0,0,1,1733.13,1029.79Z"/>',
					'square'    => '<path d="M1805,906.87a33.46,33.46,0,0,1-28.91-16.69l-49.34-85.46a33.46,33.46,0,0,1,0-33.38l49.34-85.46A33.46,33.46,0,0,1,1805,669.19h98.68a33.36,33.36,0,0,1,16.28,4.26V0H1362.85l15.79,27.35a42.13,42.13,0,0,1,0,42L1321.09,169a42.12,42.12,0,0,1-36.38,21h-115.1a42.12,42.12,0,0,1-36.37-21l-57.55-99.67a42.13,42.13,0,0,1,0-42L1091.48,0h-389L721,32.13a35.33,35.33,0,0,1,0,35.25l-51.11,88.53a35.36,35.36,0,0,1-30.53,17.62H537.17a35.36,35.36,0,0,1-30.53-17.62L455.53,67.38a35.33,35.33,0,0,1,0-35.25L474.08,0H0V252.27H15.7a51.37,51.37,0,0,1,44.37,25.62l66.32,114.87a51.39,51.39,0,0,1,2,47.35c-.7,1.09-1.38,2.19-2,3.32L60,558.31c-.76,1.3-1.47,2.63-2.15,4a51.37,51.37,0,0,1-42.19,22.2H0v37.35H15.53a51.37,51.37,0,0,1,44.36,25.62l66.33,114.87a51.38,51.38,0,0,1,0,51.23L59.89,928.43A51.38,51.38,0,0,1,15.53,954H0v966H1920V902.6a33.26,33.26,0,0,1-16.28,4.27ZM1370.39,206.08,1436.71,91.2a51.38,51.38,0,0,1,44.37-25.61h132.65a51.36,51.36,0,0,1,44.36,25.61l66.32,114.88a51.36,51.36,0,0,1,0,51.22l-66.32,114.88a51.36,51.36,0,0,1-44.36,25.61H1481.08a51.38,51.38,0,0,1-44.37-25.61L1370.39,257.3a51.36,51.36,0,0,1,0-51.22Zm210.68,395.17-16.92,29.31h-33.84l-16.92-29.31,16.92-29.31h33.84ZM731.18,207,797.51,92.14a51.38,51.38,0,0,1,44.36-25.61H974.52a51.38,51.38,0,0,1,44.36,25.61L1085.2,207a51.32,51.32,0,0,1,1,49.39c-.33.56-.68,1.12-1,1.68L1018.85,373c-.35.61-.69,1.23-1,1.85a51.38,51.38,0,0,1-43.31,23.92H841.87a51.37,51.37,0,0,1-44.36-25.62L731.18,258.25a51.38,51.38,0,0,1,0-51.23ZM411.58,392.36,477.9,277.48a51.37,51.37,0,0,1,44.36-25.62H654.91a51.39,51.39,0,0,1,44.37,25.62L765.6,392.36a51.37,51.37,0,0,1,2,47.28c-.77,1.19-1.52,2.39-2.23,3.62L699.07,558.14c-.75,1.3-1.45,2.62-2.13,4a51.36,51.36,0,0,1-42,22H522.26A51.38,51.38,0,0,1,479,560.15c-.33-.62-.67-1.24-1-1.85L411.61,443.43c-.33-.57-.67-1.12-1-1.68a51.28,51.28,0,0,1,1-49.39ZM197.43,225.86l27.9-48.33a18.5,18.5,0,0,1,16-9.21h55.8a18.49,18.49,0,0,1,16,9.21L341,225.86a18.51,18.51,0,0,1,0,18.44l-27.9,48.32a18.48,18.48,0,0,1-16,9.22H241.3a18.49,18.49,0,0,1-16-9.22l-27.9-48.32a18.51,18.51,0,0,1,0-18.44ZM92,628a51.38,51.38,0,0,1,0-51.23L158.3,461.86a51.38,51.38,0,0,1,44.36-25.61H335.31a51.38,51.38,0,0,1,44.36,25.61L446,576.74A51.38,51.38,0,0,1,446,628L379.67,742.84a51.37,51.37,0,0,1-44.36,25.62H202.66a51.37,51.37,0,0,1-44.36-25.62ZM421.26,993.09l-57.88,100.26a42.49,42.49,0,0,1-36.69,21.18H210.93a42.5,42.5,0,0,1-36.69-21.18L116.36,993.09a42.46,42.46,0,0,1,0-42.36l57.88-100.25a42.48,42.48,0,0,1,36.69-21.18H326.69a42.47,42.47,0,0,1,36.69,21.18l57.88,100.25A42.49,42.49,0,0,1,421.26,993.09Zm275.32-61.18a51.38,51.38,0,0,1-41.84,21.72H522.09A51.38,51.38,0,0,1,477.73,928L411.4,813.14a51.38,51.38,0,0,1,0-51.23L477.73,647a51.37,51.37,0,0,1,44.36-25.62H654.74A51.37,51.37,0,0,1,699.1,647l66.33,114.87a51.4,51.4,0,0,1,2,47.28c-.87,1.32-1.7,2.66-2.5,4L698.64,928.1C697.91,929.36,697.23,930.63,696.58,931.91Zm388,65.86-66.33,114.88a51.38,51.38,0,0,1-44.36,25.61H841.26a51.38,51.38,0,0,1-44.36-25.61L730.57,997.77a51.38,51.38,0,0,1,0-51.23L796.9,831.67a51.37,51.37,0,0,1,44.36-25.62H973.91a51.37,51.37,0,0,1,44.36,25.62l66.33,114.87A51.38,51.38,0,0,1,1084.6,997.77Zm.43-370-66.32,114.87a51.39,51.39,0,0,1-44.37,25.62H841.69a51.37,51.37,0,0,1-44.36-25.62L731,627.81a51.38,51.38,0,0,1,0-51.23L797.33,461.7a51.36,51.36,0,0,1,44.36-25.61H974.34a51.38,51.38,0,0,1,44.37,25.61L1085,576.58A51.38,51.38,0,0,1,1085,627.81Zm238.49,169.74-38.45,66.59a22,22,0,0,1-19,11h-76.89a22,22,0,0,1-19-11l-38.44-66.59a22,22,0,0,1,0-21.94L1170.17,709a22,22,0,0,1,19-11h76.89a22,22,0,0,1,19,11l38.45,66.59A22,22,0,0,1,1323.52,797.55Zm-29.4-214.42H1161.47a51.37,51.37,0,0,1-44.36-25.62l-66.33-114.87a51.38,51.38,0,0,1,0-51.23l66.33-114.88a51.36,51.36,0,0,1,44.36-25.61h132.65a51.36,51.36,0,0,1,44.36,25.61l66.33,114.88a51.36,51.36,0,0,1,0,51.22l-66.33,114.88A51.37,51.37,0,0,1,1294.12,583.13ZM1664.42,989l-49.56,85.85a33.74,33.74,0,0,1-29.13,16.82H1486.6a33.71,33.71,0,0,1-29.12-16.82L1407.91,989a33.73,33.73,0,0,1,0-33.63l49.57-85.85a33.71,33.71,0,0,1,29.12-16.82h99.13a33.74,33.74,0,0,1,29.13,16.82l49.56,85.85A33.71,33.71,0,0,1,1664.42,989Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M380.8,739.72l-52.87-91.57a41,41,0,0,1,0-40.83l52.87-91.57a41,41,0,0,1,35.36-20.42H521.89a41,41,0,0,1,35.36,20.42l52.87,91.57A41,41,0,0,1,611.74,645c-.69,1.06-1.36,2.13-2,3.22l-52.87,91.57c-.57,1-1.12,2-1.64,3a41,41,0,0,1-33.35,17.31H416.16A41,41,0,0,1,380.8,739.72Zm1035-193-39.33,68.12a26.71,26.71,0,0,0,0,26.61l39.33,68.12a26.68,26.68,0,0,0,23,13.31h78.66a26.69,26.69,0,0,0,23-13.31l39.33-68.12a26.72,26.72,0,0,0,0-26.61l-39.33-68.12a26.68,26.68,0,0,0-23-13.3h-78.66A26.67,26.67,0,0,0,1415.75,546.71ZM328.09,353.45,381,445q.42.74.81,1.47a40.93,40.93,0,0,0,34.52,19.07H522A40.94,40.94,0,0,0,555.53,448c.54-1.06,1.1-2.11,1.7-3.14l52.87-91.57c.56-1,1.16-1.95,1.77-2.9a40.92,40.92,0,0,0-1.61-37.68l-52.87-91.57A40.93,40.93,0,0,0,522,200.76H416.29a40.93,40.93,0,0,0-35.36,20.42l-52.86,91.57a40.81,40.81,0,0,0-.78,39.37C327.56,352.56,327.83,353,328.09,353.45Zm-78.54-120.2,22.24-38.52a14.78,14.78,0,0,0,0-14.7l-22.24-38.52a14.75,14.75,0,0,0-12.73-7.34H192.34a14.75,14.75,0,0,0-12.73,7.34L157.37,180a14.76,14.76,0,0,0,0,14.7l22.24,38.52a14.76,14.76,0,0,0,12.73,7.35h44.48A14.76,14.76,0,0,0,249.55,233.25ZM359.35,39.66a28.15,28.15,0,0,0,3.75,14.05l40.74,70.57a28.19,28.19,0,0,0,24.34,14h81.48a28.19,28.19,0,0,0,24.34-14l40.74-70.57a28.2,28.2,0,0,0,0-28.1L560,0H377.89L363.1,25.61A28.1,28.1,0,0,0,359.35,39.66ZM864.88,459.59,812,368a40.94,40.94,0,0,0-35.36-20.41H670.91A40.94,40.94,0,0,0,635.55,368l-52.87,91.57a41,41,0,0,0,0,40.83L635.55,592a41,41,0,0,0,35.36,20.42H776.65A41,41,0,0,0,812,592l52.87-91.57A40.94,40.94,0,0,0,864.88,459.59Zm-.35,294.9-52.87-91.57A41,41,0,0,0,776.3,642.5H670.57a41,41,0,0,0-35.36,20.42l-52.87,91.57a40.9,40.9,0,0,0,0,40.83l52.87,91.57a40.94,40.94,0,0,0,35.36,20.41H776.3a40.94,40.94,0,0,0,35.36-20.41l52.87-91.57A40.94,40.94,0,0,0,864.53,754.49ZM1264,679.66h-79a26.88,26.88,0,0,0-23.21,13.41l-39.51,68.43a26.87,26.87,0,0,0,0,26.8l39.51,68.44a26.87,26.87,0,0,0,23.21,13.4h79a26.87,26.87,0,0,0,23.21-13.4l39.51-68.44a26.88,26.88,0,0,0,0-26.8l-39.51-68.43A26.88,26.88,0,0,0,1264,679.66ZM577.37,185.43a40.9,40.9,0,0,0,5.45,20.42l52.87,91.57a40.94,40.94,0,0,0,35.36,20.41H776.79a40.93,40.93,0,0,0,34.52-19.06c.27-.5.53-1,.81-1.47L865,205.73c.26-.46.54-.9.81-1.35A40.93,40.93,0,0,0,865,165L812.15,73.45A41,41,0,0,0,776.79,53H671.05a41,41,0,0,0-35.36,20.42L582.82,165A40.83,40.83,0,0,0,577.37,185.43ZM902.1,618.24a17.51,17.51,0,0,0,0,17.49l30.64,53.08a17.55,17.55,0,0,0,15.15,8.74h61.29a17.54,17.54,0,0,0,15.15-8.74L1055,635.73a17.56,17.56,0,0,0,0-17.49l-30.65-53.08a17.53,17.53,0,0,0-15.15-8.75H947.89a17.54,17.54,0,0,0-15.15,8.75Zm164.8-397.82A40.94,40.94,0,0,0,1031.54,200H925.81a40.94,40.94,0,0,0-35.36,20.41L837.58,312a41,41,0,0,0,0,40.83l52.87,91.57a40.93,40.93,0,0,0,35.36,20.42h105.73a40.93,40.93,0,0,0,35.36-20.42l52.87-91.57a40.94,40.94,0,0,0,0-40.83ZM857.43,21.8a33.58,33.58,0,0,0,0,33.48l45.87,79.46a33.58,33.58,0,0,0,29,16.74H1024a33.58,33.58,0,0,0,29-16.74l45.87-79.46a33.58,33.58,0,0,0,0-33.48L1086.33,0H870ZM1219.8,502.62h27l13.49-23.37-13.49-23.36h-27l-13.48,23.36ZM1145.2,72.69l-52.87,91.57a41,41,0,0,0,0,40.84l52.87,91.56a40.93,40.93,0,0,0,35.36,20.42H1286.3a40.93,40.93,0,0,0,35.36-20.42l52.87-91.57a40.94,40.94,0,0,0,0-40.83l-52.87-91.57a40.94,40.94,0,0,0-35.36-20.41H1180.56A40.94,40.94,0,0,0,1145.2,72.69ZM47.74,740.05l52.87-91.57a40.94,40.94,0,0,0,0-40.83L47.74,516.08a41,41,0,0,0-35.36-20.42H0v264.8H12.38A40.94,40.94,0,0,0,47.74,740.05ZM46.15,448.19c.54-1.07,1.1-2.12,1.71-3.17l52.86-91.57q.78-1.33,1.62-2.64a41,41,0,0,0-1.59-37.74L47.88,221.5a40.94,40.94,0,0,0-35.36-20.41H0v264.8H12.52A41,41,0,0,0,46.15,448.19Zm243.5,423.32,46.14-79.92a33.86,33.86,0,0,0,0-33.76l-46.14-79.92A33.86,33.86,0,0,0,260.41,661H168.13a33.86,33.86,0,0,0-29.24,16.88L92.75,757.83a33.84,33.84,0,0,0,0,33.76l46.14,79.92a33.86,33.86,0,0,0,29.24,16.88h92.28A33.86,33.86,0,0,0,289.65,871.51Zm13-279.39,52.86-91.57a40.94,40.94,0,0,0,0-40.83l-52.86-91.57a41,41,0,0,0-35.37-20.41H161.54a40.94,40.94,0,0,0-35.36,20.41L73.31,459.72a41,41,0,0,0,0,40.83l52.87,91.57a41,41,0,0,0,35.36,20.42H267.27A41,41,0,0,0,302.64,592.12Z"/>',
					'portrait'  => '<path d="M474.33,70.16a36.83,36.83,0,0,1,0-36.71L493.65,0H731.49l19.32,33.45a36.84,36.84,0,0,1,0,36.71l-53.23,92.19A36.79,36.79,0,0,1,665.8,180.7H559.35a36.79,36.79,0,0,1-31.79-18.35ZM428.6,461.73l69.06,119.62c.37.64.72,1.28,1.07,1.92a53.45,53.45,0,0,0,45.09,24.91H682a53.49,53.49,0,0,0,43.76-22.89c.71-1.38,1.44-2.75,2.22-4.1L797,461.56c.75-1.28,1.53-2.53,2.32-3.77a53.49,53.49,0,0,0-2.1-49.24L728.14,288.93A53.49,53.49,0,0,0,682,262.26H543.82a53.49,53.49,0,0,0-46.19,26.67L428.57,408.55a53.36,53.36,0,0,0-1,51.44C427.9,460.57,428.26,461.14,428.6,461.73Zm-194-157a19.23,19.23,0,0,0,16.62,9.6h58.11A19.25,19.25,0,0,0,326,304.7l29.06-50.32a19.3,19.3,0,0,0,0-19.2L326,184.86a19.25,19.25,0,0,0-16.62-9.59H251.26a19.22,19.22,0,0,0-16.62,9.59l-29.06,50.32a19.28,19.28,0,0,0,0,19.2Zm-146,322.52a53.31,53.31,0,0,0,7.12,26.67l69.06,119.62A53.49,53.49,0,0,0,211,800.18H349.15a53.47,53.47,0,0,0,46.19-26.67l69.07-119.62a53.5,53.5,0,0,0,0-53.34L395.34,480.93a53.47,53.47,0,0,0-46.19-26.67H211a53.49,53.49,0,0,0-46.19,26.67L95.77,600.55A53.33,53.33,0,0,0,88.65,627.22ZM1180,176a43.86,43.86,0,0,0,37.88,21.87h119.85A43.87,43.87,0,0,0,1375.63,176l59.92-103.79a43.85,43.85,0,0,0,0-43.74L1419.11,0H1136.53l-16.44,28.48a43.87,43.87,0,0,0,0,43.74Zm395.84,450.06,17.62,30.52h35.24l17.62-30.52-17.62-30.52h-35.24Zm-156-384.82a53.28,53.28,0,0,0,7.12,26.67L1496,387.54a53.5,53.5,0,0,0,46.2,26.67h138.12a53.5,53.5,0,0,0,46.2-26.67l69.06-119.62a53.48,53.48,0,0,0,0-53.34L1726.54,95a53.5,53.5,0,0,0-46.2-26.67H1542.22A53.5,53.5,0,0,0,1496,95L1427,214.58A53.33,53.33,0,0,0,1419.84,241.25ZM761.36,268.91l69.07,119.62a53.49,53.49,0,0,0,46.19,26.67h138.13a53.48,53.48,0,0,0,45.09-24.91c.35-.64.7-1.29,1.07-1.92L1130,268.75c.34-.59.7-1.17,1-1.75a53.46,53.46,0,0,0-1-51.43L1060.94,96a53.49,53.49,0,0,0-46.19-26.67H876.62A53.49,53.49,0,0,0,830.43,96L761.36,215.57a53.51,53.51,0,0,0,0,53.34ZM131.43,793.79,62.37,674.17a53.5,53.5,0,0,0-46.2-26.67H0V993.42H16.17a53.5,53.5,0,0,0,46.2-26.67l69.06-119.62A53.48,53.48,0,0,0,131.43,793.79ZM60.28,585.49c.71-1.39,1.45-2.78,2.24-4.14l69.06-119.62c.68-1.17,1.39-2.32,2.11-3.45a53.52,53.52,0,0,0-2.08-49.3L62.55,289.36a53.5,53.5,0,0,0-46.2-26.67H0V608.61H16.35A53.48,53.48,0,0,0,60.28,585.49ZM1879.56,696.81a34.87,34.87,0,0,0-30.11,17.38l-51.38,89a34.87,34.87,0,0,0,0,34.76l51.38,89a34.87,34.87,0,0,0,30.11,17.38H1920V696.81ZM1462.8,407.57,1393.74,288a53.5,53.5,0,0,0-46.2-26.67H1209.42A53.47,53.47,0,0,0,1163.23,288l-69.07,119.62a53.51,53.51,0,0,0,0,53.34l69.07,119.62a53.47,53.47,0,0,0,46.19,26.67h138.12a53.5,53.5,0,0,0,46.2-26.67l69.06-119.62A53.48,53.48,0,0,0,1462.8,407.57Zm218.72,497.81a35.11,35.11,0,0,0-30.32-17.51H1548a35.13,35.13,0,0,0-30.33,17.51L1466,994.78a35.08,35.08,0,0,0,0,35l51.61,89.4A35.13,35.13,0,0,0,1548,1136.7H1651.2a35.11,35.11,0,0,0,30.32-17.51l51.61-89.4a35.08,35.08,0,0,0,0-35ZM1060.31,866a53.5,53.5,0,0,0-46.2-26.67H876A53.5,53.5,0,0,0,829.79,866L760.73,985.62a53.51,53.51,0,0,0,0,53.34l69.06,119.62a53.5,53.5,0,0,0,46.2,26.67h138.12a53.5,53.5,0,0,0,46.2-26.67L1129.37,1039a53.48,53.48,0,0,0,0-53.34Zm277.81-127.71a22.9,22.9,0,0,0-19.78-11.43h-80.07a22.91,22.91,0,0,0-19.79,11.43l-40,69.34a22.86,22.86,0,0,0,0,22.85l40,69.34a22.92,22.92,0,0,0,19.79,11.42h80.07a22.91,22.91,0,0,0,19.78-11.42l40-69.34a22.91,22.91,0,0,0,0-22.85ZM378.38,885.59a44.23,44.23,0,0,0-38.2-22.06H219.63a44.21,44.21,0,0,0-38.19,22.06L121.16,990a44.24,44.24,0,0,0,0,44.11l60.28,104.39a44.21,44.21,0,0,0,38.19,22.06H340.18a44.23,44.23,0,0,0,38.2-22.06l60.27-104.39a44.23,44.23,0,0,0,0-44.11Zm420.76-43A53.45,53.45,0,0,0,797,793.37L728,673.75a53.49,53.49,0,0,0-46.19-26.67H543.64a53.49,53.49,0,0,0-46.19,26.67L428.39,793.37a53.45,53.45,0,0,0,0,53.34l69.06,119.62A53.49,53.49,0,0,0,543.64,993H681.77a53.5,53.5,0,0,0,43.56-22.61c.69-1.34,1.39-2.67,2.15-4L796.54,846.8Q797.79,844.66,799.14,842.59Zm261.62-361.83a53.49,53.49,0,0,0-46.19-26.67H876.44a53.49,53.49,0,0,0-46.19,26.67L761.18,600.38a53.51,53.51,0,0,0,0,53.34l69.07,119.62A53.49,53.49,0,0,0,876.44,800h138.13a53.49,53.49,0,0,0,46.19-26.67l69.06-119.62a53.48,53.48,0,0,0,0-53.34Z"/>',
					'square'    => '<path d="M15.7,584.48H0V252.27H15.7a51.37,51.37,0,0,1,44.37,25.62l66.32,114.88a51.37,51.37,0,0,1,2,47.34c-.7,1.09-1.38,2.19-2,3.32L60,558.31c-.76,1.3-1.47,2.63-2.15,4A51.37,51.37,0,0,1,15.7,584.48ZM225.33,292.62a18.49,18.49,0,0,0,16,9.22h55.8a18.48,18.48,0,0,0,16-9.22L341,244.3a18.51,18.51,0,0,0,0-18.44l-27.9-48.33a18.49,18.49,0,0,0-16-9.21H241.3a18.5,18.5,0,0,0-16,9.21l-27.9,48.33a18.51,18.51,0,0,0,0,18.44ZM411.61,443.43,477.93,558.3c.35.61.69,1.23,1,1.85a51.38,51.38,0,0,0,43.31,23.92H654.91a51.36,51.36,0,0,0,42-22c.68-1.33,1.38-2.65,2.13-4L765.4,443.26c.71-1.23,1.46-2.43,2.22-3.62a51.34,51.34,0,0,0-2-47.28L699.28,277.48a51.39,51.39,0,0,0-44.37-25.62H522.26a51.37,51.37,0,0,0-44.36,25.62L411.58,392.36a51.28,51.28,0,0,0-1,49.39C410.94,442.31,411.28,442.86,411.61,443.43Zm951.94-211.74a51.2,51.2,0,0,0,6.84,25.61l66.32,114.88a51.38,51.38,0,0,0,44.37,25.61h132.65a51.36,51.36,0,0,0,44.36-25.61l66.32-114.88a51.36,51.36,0,0,0,0-51.22L1658.09,91.2a51.36,51.36,0,0,0-44.36-25.61H1481.08a51.38,51.38,0,0,0-44.37,25.61l-66.32,114.88A51.18,51.18,0,0,0,1363.55,231.69ZM85.13,602.35A51.24,51.24,0,0,0,92,628L158.3,742.84a51.37,51.37,0,0,0,44.36,25.62H335.31a51.37,51.37,0,0,0,44.36-25.62L446,628a51.38,51.38,0,0,0,0-51.23L379.67,461.86a51.38,51.38,0,0,0-44.36-25.61H202.66a51.38,51.38,0,0,0-44.36,25.61L92,576.74A51.23,51.23,0,0,0,85.13,602.35ZM506.64,155.91a35.36,35.36,0,0,0,30.53,17.62H639.4a35.36,35.36,0,0,0,30.53-17.62L721,67.38a35.33,35.33,0,0,0,0-35.25L702.49,0H474.08L455.53,32.13a35.33,35.33,0,0,0,0,35.25ZM1133.24,169a42.12,42.12,0,0,0,36.37,21h115.1a42.12,42.12,0,0,0,36.38-21l57.55-99.67a42.13,42.13,0,0,0,0-42L1362.85,0H1091.48l-15.79,27.35a42.13,42.13,0,0,0,0,42Zm380.15,432.22,16.92,29.31h33.84l16.92-29.31-16.92-29.31h-33.84Zm-782.21-343,66.33,114.87a51.37,51.37,0,0,0,44.36,25.62H974.52a51.38,51.38,0,0,0,43.31-23.92c.33-.62.67-1.24,1-1.85l66.33-114.88c.32-.56.67-1.12,1-1.68a51.32,51.32,0,0,0-1-49.39L1018.88,92.14a51.38,51.38,0,0,0-44.36-25.61H841.87a51.38,51.38,0,0,0-44.36,25.61L731.18,207a51.38,51.38,0,0,0,0,51.23ZM1018.71,461.7a51.38,51.38,0,0,0-44.37-25.61H841.69a51.36,51.36,0,0,0-44.36,25.61L731,576.58a51.38,51.38,0,0,0,0,51.23l66.32,114.87a51.37,51.37,0,0,0,44.36,25.62H974.34a51.39,51.39,0,0,0,44.37-25.62L1085,627.81a51.38,51.38,0,0,0,0-51.23Zm885,207.49H1805a33.46,33.46,0,0,0-28.91,16.69l-49.34,85.46a33.46,33.46,0,0,0,0,33.38l49.34,85.46A33.46,33.46,0,0,0,1805,906.87h98.68A33.26,33.26,0,0,0,1920,902.6V673.45A33.36,33.36,0,0,0,1903.72,669.19Zm-288.86,200.3a33.74,33.74,0,0,0-29.13-16.82H1486.6a33.71,33.71,0,0,0-29.12,16.82l-49.57,85.85a33.73,33.73,0,0,0,0,33.63l49.57,85.85a33.71,33.71,0,0,0,29.12,16.82h99.13a33.74,33.74,0,0,0,29.13-16.82L1664.42,989a33.71,33.71,0,0,0,0-33.63ZM126.22,762.32,59.89,647.45a51.37,51.37,0,0,0-44.36-25.62H0V954H15.53a51.38,51.38,0,0,0,44.36-25.61l66.33-114.88A51.38,51.38,0,0,0,126.22,762.32ZM1404.81,391.41l-66.33-114.88a51.36,51.36,0,0,0-44.36-25.61H1161.47a51.36,51.36,0,0,0-44.36,25.61l-66.33,114.88a51.38,51.38,0,0,0,0,51.23l66.33,114.87a51.37,51.37,0,0,0,44.36,25.62h132.65a51.37,51.37,0,0,0,44.36-25.62l66.33-114.88A51.36,51.36,0,0,0,1404.81,391.41ZM767.46,809.19a51.4,51.4,0,0,0-2-47.28L699.1,647a51.37,51.37,0,0,0-44.36-25.62H522.09A51.37,51.37,0,0,0,477.73,647L411.4,761.91a51.38,51.38,0,0,0,0,51.23L477.73,928a51.38,51.38,0,0,0,44.36,25.61H654.74a51.4,51.4,0,0,0,41.84-21.71c.65-1.29,1.33-2.56,2.06-3.82L765,813.23C765.76,811.85,766.59,810.51,767.46,809.19ZM1285.07,709a22,22,0,0,0-19-11h-76.89a22,22,0,0,0-19,11l-38.44,66.59a22,22,0,0,0,0,21.94l38.44,66.59a22,22,0,0,0,19,11h76.89a22,22,0,0,0,19-11l38.45-66.59a22,22,0,0,0,0-21.94ZM363.38,850.48a42.47,42.47,0,0,0-36.69-21.18H210.93a42.48,42.48,0,0,0-36.69,21.18L116.36,950.73a42.46,42.46,0,0,0,0,42.36l57.88,100.26a42.5,42.5,0,0,0,36.69,21.18H326.69a42.49,42.49,0,0,0,36.69-21.18l57.88-100.26a42.49,42.49,0,0,0,0-42.36Zm654.89-18.81a51.37,51.37,0,0,0-44.36-25.62H841.26a51.37,51.37,0,0,0-44.36,25.62L730.57,946.54a51.38,51.38,0,0,0,0,51.23l66.33,114.88a51.38,51.38,0,0,0,44.36,25.61H973.91a51.38,51.38,0,0,0,44.36-25.61l66.33-114.88a51.38,51.38,0,0,0,0-51.23Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Honeycomb();
